package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask for setting the correct position of all active persons
 * after some of them were deleted.
 * Created by david on 08.03.16.
 */
public class SetPositionByNumberOfSoftDeletedPersonInDb
        extends AsyncTask<String, Integer, List<Person>> {

    private ISetPosBySoftDeleted iDecrementPosition;
    private List<Person> mPersons;
    private PersonDao mPersonDao;
    private Context mContext;

    public SetPositionByNumberOfSoftDeletedPersonInDb(Context context,
                                                      ISetPosBySoftDeleted
                                                              iDecrementPosition,
                                                      List<Person> persons) {
        this.iDecrementPosition = iDecrementPosition;
        mPersons = persons;
        mContext = context;
    }

    @Override
    protected List<Person> doInBackground(String... params) {
        mPersonDao = new PersonDao(mContext);
        mPersonDao.openWritable();
        int pos = 1;
        for (Person p : mPersons) {
            while (p.getPosition() != pos) {
                p.setPosition(p.getPosition()-1);
            }
            pos++;
            mPersonDao.update(p);
        }
        return mPersons;
    }

    @Override
    protected void onPostExecute(List<Person> persons) {
        super.onPostExecute(persons);
        iDecrementPosition.onSetPosBySoftDelPers(persons);
        mPersonDao.close();

    }

    public interface ISetPosBySoftDeleted {
        void onSetPosBySoftDelPers(List<Person> persons);
    }
}
